<?php
$pageTitle = 'Welcome to Documentation';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>Welcome to Documentation</h1>

<div class="alert alert-info">
    <strong>Status:</strong> To check License.Cheap status and ongoing maintenance visit: 
    <a href="https://status.license.cheap" target="_blank">status.License.Cheap</a>
</div>

<div class="alert alert-warning">
    <strong>⚠ Avoid datacenter abuse notice with our license verify!</strong><br>
    <em>Only for cPanel licenses</em><br><br>
    To get a verification at verify.cpanel.net run this command:
    <div class="command-box dark">touch /etc/.verifylicense ; <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></div>
</div>

<h2>Latest Updates</h2>

<h3>AlmaLinux 9, Rocky Linux 9 and Ubuntu 22.04 are now supported!</h3>
<p>We are excited to announce support for the latest operating systems. These are now fully compatible with our licensing system.</p>

<h3>AlmaLinux 10 Support Available</h3>
<p><strong>AlmaLinux 10</strong> is now supported for cPanel licensing system. AlmaLinux 10 is supported by cPanel from version 132+. 
<a href="?page=installation">Read our announcement</a> before attempting to update to version 132.</p>

<h2>Supported Operating Systems</h2>

<h3>Supported OS for cPanel license</h3>
<table>
    <thead>
        <tr>
            <th>Operating Systems</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($supportedOS['cPanel'] as $os): ?>
            <tr>
                <td><?php echo htmlspecialchars($os); ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<h3>Supported OS for other licenses</h3>
<table>
    <thead>
        <tr>
            <th>Operating Systems</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($supportedOS['other'] as $os): ?>
            <tr>
                <td><?php echo htmlspecialchars($os); ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<p><strong>If your OS is not listed here, please contact support to be added to our system's supported OS.</strong></p>

<h3>First Time Installing cPanel on AlmaLinux 8/RockyLinux 8?</h3>
<p>Make sure to enable network manager before rebooting cPanel server for the first time. 
<a href="?page=installation">Read article</a> for more information.</p>

<?php include '../includes/footer.php'; ?>
