<?php
$pageTitle = 'SSL Settings for cPanel';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>SSL Settings for cPanel</h1>

<h2>Overview</h2>
<p>Proper SSL configuration is crucial for secure server operations. This guide covers SSL settings and best practices for cPanel servers using RC Licensing System.</p>

<h2>SSL Certificate Management</h2>

<h3>Installing SSL Certificates</h3>
<p>cPanel provides multiple ways to install SSL certificates:</p>

<ul>
    <li><strong>AutoSSL:</strong> Automatic SSL certificate installation and renewal</li>
    <li><strong>Let's Encrypt:</strong> Free SSL certificates with automatic renewal</li>
    <li><strong>Commercial Certificates:</strong> Third-party SSL certificate providers</li>
    <li><strong>Self-Signed Certificates:</strong> For testing purposes only</li>
</ul>

<h3>AutoSSL Configuration</h3>
<p>AutoSSL is the recommended method for automatic SSL certificate management. It automatically installs and renews certificates for your domains.</p>

<h4>Enabling AutoSSL:</h4>
<ol>
    <li>Log in to cPanel</li>
    <li>Navigate to SSL/TLS Manager</li>
    <li>Click on "Manage AutoSSL"</li>
    <li>Select your preferred certificate provider</li>
    <li>Enable AutoSSL for your domains</li>
</ol>

<h2>FleetSSL</h2>

<p>FleetSSL comes free with your cPanel license and provides advanced SSL management features.</p>

<h3>Activating FleetSSL</h3>
<p>To activate FleetSSL on your server, run:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?> -fleetssl</code></pre>

<h3>FleetSSL Benefits</h3>
<ul>
    <li>Automatic SSL certificate installation</li>
    <li>Multi-domain certificate support</li>
    <li>Automatic certificate renewal</li>
    <li>Integrated with cPanel</li>
</ul>

<h2>SSL/TLS Best Practices</h2>

<h3>Security Recommendations</h3>
<ul>
    <li>Always use HTTPS for all connections</li>
    <li>Keep SSL certificates up to date</li>
    <li>Use strong encryption protocols (TLS 1.2 or higher)</li>
    <li>Disable older SSL/TLS versions (SSL 3.0, TLS 1.0, TLS 1.1)</li>
    <li>Regularly monitor certificate expiration dates</li>
</ul>

<h3>Cipher Suite Configuration</h3>
<p>Configure strong cipher suites in your Apache configuration:</p>

<pre><code>SSLProtocol TLSv1.2 TLSv1.3
SSLCipherSuite HIGH:!aNULL:!MD5
SSLHonorCipherOrder on</code></pre>

<h2>Troubleshooting SSL Issues</h2>

<h3>Certificate Installation Failed</h3>
<p>If certificate installation fails:</p>
<ul>
    <li>Verify domain ownership</li>
    <li>Check DNS records are properly configured</li>
    <li>Ensure port 80 and 443 are accessible</li>
    <li>Review cPanel error logs</li>
</ul>

<h3>Certificate Expiration Warnings</h3>
<p>If you receive certificate expiration warnings:</p>
<ul>
    <li>Log in to cPanel</li>
    <li>Navigate to SSL/TLS Manager</li>
    <li>Check certificate expiration dates</li>
    <li>Renew certificates before expiration</li>
</ul>

<h3>Mixed Content Warnings</h3>
<p>Mixed content warnings occur when HTTPS pages load HTTP resources:</p>
<ul>
    <li>Update all resource URLs to use HTTPS</li>
    <li>Use relative URLs when possible</li>
    <li>Configure automatic HTTPS redirects</li>
</ul>

<h2>Updating SSL Certificates</h2>

<p>To update your cPanel license and SSL settings, run:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h2>Additional Resources</h2>

<ul>
    <li><a href="?page=security">Security TIPS for cPanel</a></li>
    <li><a href="?page=installation">Installation Guide</a></li>
    <li><a href="https://cpanel.net" target="_blank">cPanel Official Documentation</a></li>
</ul>

<?php include '../includes/footer.php'; ?>
