<?php
$pageTitle = 'Security TIPS for cPanel';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>Security TIPS for cPanel</h1>

<h2>Overview</h2>
<p>Security is paramount for any server. This guide provides essential security tips and best practices for cPanel servers running RC Licensing System.</p>

<h2>System Security</h2>

<h3>Keep Your System Updated</h3>
<p>Regularly update your operating system and all installed packages:</p>
<pre><code>yum update -y  # For CentOS/RHEL/CloudLinux
apt-get update && apt-get upgrade -y  # For Ubuntu/Debian</code></pre>

<h3>Firewall Configuration</h3>
<p>Implement a robust firewall to protect your server:</p>
<ul>
    <li>Allow only necessary ports (80, 443, 22 for SSH)</li>
    <li>Use CSF (ConfigServer Firewall) or UFW</li>
    <li>Implement rate limiting for SSH connections</li>
    <li>Block suspicious IP addresses automatically</li>
</ul>

<h3>SSH Security</h3>
<p>Secure your SSH access:</p>
<ul>
    <li>Change default SSH port (22) to a non-standard port</li>
    <li>Disable root login via SSH</li>
    <li>Use SSH keys instead of passwords</li>
    <li>Implement fail2ban for brute-force protection</li>
    <li>Limit SSH login attempts</li>
</ul>

<h2>cPanel Security</h2>

<h3>cPanel Access Control</h3>
<ul>
    <li>Use strong passwords for cPanel accounts</li>
    <li>Enable two-factor authentication</li>
    <li>Restrict cPanel access by IP address</li>
    <li>Regularly audit user accounts</li>
    <li>Remove unused accounts</li>
</ul>

<h3>File Permissions</h3>
<p>Maintain proper file permissions:</p>
<pre><code>chmod 644 /home/user/public_html/*.php  # PHP files
chmod 755 /home/user/public_html/       # Directories
chmod 600 /home/user/.ssh/authorized_keys  # SSH keys</code></pre>

<h3>Database Security</h3>
<ul>
    <li>Use strong database passwords</li>
    <li>Limit database user privileges</li>
    <li>Disable remote database access when not needed</li>
    <li>Regularly backup databases</li>
    <li>Use database user accounts with minimal required privileges</li>
</ul>

<h2>License Verification</h2>

<h3>Avoid Datacenter Abuse Notices</h3>
<p>Verify your cPanel license to avoid datacenter abuse notices:</p>
<pre><code>touch /etc/.verifylicense ; <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h3>Regular License Updates</h3>
<p>Keep your license updated:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h2>Malware Protection</h2>

<h3>Imunify360</h3>
<p>Consider using Imunify360 for comprehensive malware protection:</p>
<pre><code>bash &lt;( curl <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh ) Imunify360; <?php echo htmlspecialchars($licenseTypes['imunify360']['prefix']); ?></code></pre>

<h3>Regular Scanning</h3>
<ul>
    <li>Scan for malware regularly</li>
    <li>Monitor file integrity</li>
    <li>Review access logs for suspicious activity</li>
    <li>Use antivirus software</li>
</ul>

<h2>Backup and Disaster Recovery</h2>

<h3>Regular Backups</h3>
<ul>
    <li>Implement automated daily backups</li>
    <li>Store backups on remote servers</li>
    <li>Test backup restoration regularly</li>
    <li>Maintain multiple backup copies</li>
</ul>

<h3>JetBackup Integration</h3>
<p>Use JetBackup for comprehensive backup management:</p>
<pre><code>bash &lt;( curl <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh ) JetBackup; <?php echo htmlspecialchars($licenseTypes['jetbackup']['prefix']); ?></code></pre>

<h2>Monitoring and Logging</h2>

<h3>Server Monitoring</h3>
<ul>
    <li>Monitor CPU, memory, and disk usage</li>
    <li>Set up alerts for resource thresholds</li>
    <li>Monitor network traffic</li>
    <li>Track failed login attempts</li>
</ul>

<h3>Log Management</h3>
<ul>
    <li>Enable comprehensive logging</li>
    <li>Regularly review system logs</li>
    <li>Archive old logs</li>
    <li>Monitor for suspicious patterns</li>
</ul>

<h2>Web Application Security</h2>

<h3>Web Application Firewall</h3>
<ul>
    <li>Implement ModSecurity</li>
    <li>Use OWASP ModSecurity Core Rule Set</li>
    <li>Protect against SQL injection, XSS, and other attacks</li>
</ul>

<h3>PHP Security</h3>
<ul>
    <li>Keep PHP updated</li>
    <li>Disable dangerous PHP functions</li>
    <li>Use PHP security extensions</li>
    <li>Validate and sanitize user input</li>
</ul>

<h2>Security Checklist</h2>

<ul>
    <li>☐ System and software are up to date</li>
    <li>☐ Firewall is properly configured</li>
    <li>☐ SSH is secured</li>
    <li>☐ Strong passwords are in use</li>
    <li>☐ License is verified and updated</li>
    <li>☐ Backups are configured and tested</li>
    <li>☐ Monitoring and logging are enabled</li>
    <li>☐ Malware protection is active</li>
    <li>☐ SSL certificates are valid</li>
    <li>☐ Regular security audits are performed</li>
</ul>

<?php include '../includes/footer.php'; ?>
