<?php
$pageTitle = 'Verify LiteSpeed License';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>Verify LiteSpeed License Core/Worker Numbers</h1>

<h2>Overview</h2>
<p>LiteSpeed Web Server is a high-performance web server that can significantly improve your website's performance. This guide explains how to verify your LiteSpeed license and check core/worker numbers.</p>

<h2>What are Core and Worker Numbers?</h2>

<h3>CPU Cores</h3>
<p>The number of CPU cores determines the maximum number of worker processes your LiteSpeed server can run. Each core can handle one worker process.</p>

<h3>Worker Processes</h3>
<p>Worker processes handle incoming requests. The number of workers should match your CPU core count for optimal performance.</p>

<h2>Checking Your License Information</h2>

<h3>View License Details</h3>
<p>To view your LiteSpeed license information, run:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['liteSpeed']['prefix']); ?></code></pre>

<h3>License Status Output</h3>
<p>The output will show:</p>
<ul>
    <li>License type and expiration date</li>
    <li>Number of CPU cores</li>
    <li>Number of worker processes</li>
    <li>License status (Active/Expired)</li>
</ul>

<h2>Installation and Setup</h2>

<h3>Installing LiteSpeed License</h3>
<p>To install or update your LiteSpeed license, run:</p>
<pre><code>bash &lt;( curl <?php echo htmlspecialchars($mirrorUrl); ?>/pre.sh ) liteSpeed; <?php echo htmlspecialchars($licenseTypes['liteSpeed']['prefix']); ?></code></pre>

<h3>Updating License</h3>
<p>To update your existing LiteSpeed license:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['liteSpeed']['prefix']); ?></code></pre>

<h2>Performance Optimization</h2>

<h3>Configuring Worker Processes</h3>
<p>Optimal worker configuration depends on your CPU cores:</p>

<table>
    <thead>
        <tr>
            <th>CPU Cores</th>
            <th>Recommended Workers</th>
            <th>Max Connections</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>1-2</td>
            <td>1-2</td>
            <td>500-1000</td>
        </tr>
        <tr>
            <td>4-8</td>
            <td>4-8</td>
            <td>2000-4000</td>
        </tr>
        <tr>
            <td>16+</td>
            <td>16+</td>
            <td>8000+</td>
        </tr>
    </tbody>
</table>

<h3>LiteSpeed Configuration Files</h3>
<p>Main configuration file location:</p>
<pre><code>/usr/local/lsws/conf/httpd_config.conf</code></pre>

<h3>Restarting LiteSpeed</h3>
<p>After making configuration changes, restart LiteSpeed:</p>
<pre><code>/usr/local/lsws/bin/lswsctrl restart</code></pre>

<h2>Monitoring and Troubleshooting</h2>

<h3>Checking LiteSpeed Status</h3>
<p>To check if LiteSpeed is running:</p>
<pre><code>ps aux | grep lsws</code></pre>

<h3>Viewing LiteSpeed Logs</h3>
<p>LiteSpeed logs location:</p>
<pre><code>/usr/local/lsws/logs/</code></pre>

<h3>Common Issues</h3>

<h4>License Expired</h4>
<p>If your license has expired, update it immediately:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['liteSpeed']['prefix']); ?></code></pre>

<h4>Worker Limit Reached</h4>
<p>If you're hitting worker limits, consider upgrading your license or adding more CPU cores.</p>

<h4>Performance Issues</h4>
<ul>
    <li>Check CPU and memory usage</li>
    <li>Verify worker process count</li>
    <li>Review LiteSpeed logs for errors</li>
    <li>Optimize PHP settings</li>
</ul>

<h2>License Types and Limits</h2>

<table>
    <thead>
        <tr>
            <th>License Type</th>
            <th>CPU Cores</th>
            <th>Workers</th>
            <th>Best For</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td>Trial</td>
            <td>Unlimited</td>
            <td>Unlimited</td>
            <td>Testing</td>
        </tr>
        <tr>
            <td>Standard</td>
            <td>Up to 2</td>
            <td>Up to 2</td>
            <td>Small sites</td>
        </tr>
        <tr>
            <td>Professional</td>
            <td>Up to 8</td>
            <td>Up to 8</td>
            <td>Medium sites</td>
        </tr>
        <tr>
            <td>Enterprise</td>
            <td>Unlimited</td>
            <td>Unlimited</td>
            <td>Large sites</td>
        </tr>
    </tbody>
</table>

<h2>Performance Benefits</h2>

<ul>
    <li>Up to 3x faster than Apache</li>
    <li>Lower memory consumption</li>
    <li>Better handling of concurrent connections</li>
    <li>Improved SSL/TLS performance</li>
    <li>Built-in caching mechanisms</li>
</ul>

<?php include '../includes/footer.php'; ?>
