<?php
$pageTitle = 'FAQ';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>Frequently Asked Questions</h1>

<h2>General Questions</h2>

<h3>What is RC Licensing System?</h3>
<p>RC Licensing System is a comprehensive licensing solution for various server management and control panel applications. It provides automated installation, updates, and management of licenses across different platforms.</p>

<h3>Which operating systems are supported?</h3>
<p>We support a wide range of operating systems including CentOS, CloudLinux, AlmaLinux, Rocky Linux, Ubuntu, Debian, and FreeBSD. For a complete list, please visit the <a href="?page=welcome">Welcome page</a>.</p>

<h3>Do I need root access to install?</h3>
<p>Yes, you must run the installation script at root level for it to work properly.</p>

<h2>Installation Questions</h2>

<h3>What is the difference between Trial and Purchased licenses?</h3>
<p><strong>Trial License:</strong> Available for 3-7 days, no limitations, includes support.</p>
<p><strong>Purchased License:</strong> Full access to licensing system, free support, no limitations.</p>

<h3>How do I remove a previous license installation?</h3>
<p>Use the following command:</p>
<pre><code>wget -O remover <?php echo htmlspecialchars($mirrorUrl); ?>/remover; chmod +x remover; ./remover</code></pre>

<h3>How do I update my license?</h3>
<p>Simply run the license command for your product type. For example, for cPanel:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h2>cPanel Specific Questions</h2>

<h3>How do I verify my cPanel license?</h3>
<p>To get a verification at verify.cpanel.net and avoid datacenter abuse notices, run:</p>
<pre><code>touch /etc/.verifylicense ; <?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?></code></pre>

<h3>What is FleetSSL?</h3>
<p>FleetSSL comes free with your cPanel license. To activate it, run:</p>
<pre><code><?php echo htmlspecialchars($licenseTypes['cPanel']['prefix']); ?> -fleetssl</code></pre>

<h3>I'm installing cPanel on AlmaLinux 8/RockyLinux 8 for the first time. What should I do?</h3>
<p>Make sure to enable network manager before rebooting cPanel server for the first time. This ensures proper network connectivity during the installation process.</p>

<h2>Troubleshooting</h2>

<h3>The installation script is not working. What should I do?</h3>
<p>Please ensure:</p>
<ul>
    <li>You are running the script as root user</li>
    <li>Your server has internet connectivity</li>
    <li>The mirror URL is accessible: <?php echo htmlspecialchars($mirrorUrl); ?></li>
    <li>Your operating system is in our supported list</li>
</ul>

<h3>Where can I get support?</h3>
<p>For support and additional help, please visit our website at <a href="https://license.cheap" target="_blank">license.cheap</a> or check the status page at <a href="https://status.license.cheap" target="_blank">status.license.cheap</a>.</p>

<h3>How do I contact support?</h3>
<p>You can reach out to us through our website. For trial licenses, support is included. For purchased licenses, you have free support access.</p>

<h2>License Commands</h2>

<p>Here are the common license commands for different products:</p>

<table>
    <thead>
        <tr>
            <th>Product</th>
            <th>Update Command</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($licenseTypes as $type => $info): ?>
            <tr>
                <td><?php echo htmlspecialchars($info['description']); ?></td>
                <td><code><?php echo htmlspecialchars($info['prefix']); ?></code></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<?php include '../includes/footer.php'; ?>
