<?php
/**
 * RC Licensing System - Configuration File
 * 
 * This file contains all configurable variables for the licensing documentation system
 */

// Mirror URL for downloading installation scripts and files
$mirrorUrl = 'https://mirror.resellercenter.ir';

// User Agent for curl requests
$userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36';

// License prefix - used for all license command prefixes
$prefix = 'RcLicense';

// License types with their specific prefixes
$licenseTypes = [
    'cPanel' => [
        'prefix' => 'RcLicenseCP',
        'script' => 'cPanel',
        'description' => 'cPanel License'
    ],
    'liteSpeed' => [
        'prefix' => 'RcLicenseLSWS',
        'script' => 'liteSpeed',
        'description' => 'LiteSpeed License'
    ],
    'cloudLinux' => [
        'prefix' => 'RcLicenseCLN',
        'script' => 'CloudLinux',
        'description' => 'CloudLinux License'
    ],
    'imunify360' => [
        'prefix' => 'RcLicenseImunify360',
        'script' => 'Imunify360',
        'description' => 'Imunify360 License'
    ],
    'wordpress' => [
        'prefix' => 'RcLicenseWP',
        'script' => 'wp2',
        'description' => 'WordPress License'
    ],
    'softaculous' => [
        'prefix' => 'RcLicenseSoftaculous',
        'script' => 'Softaculous',
        'description' => 'Softaculous License'
    ],
    'sitepad' => [
        'prefix' => 'RcLicenseSitepad',
        'script' => 'Sitepad',
        'description' => 'Sitepad License'
    ],
    'plesk' => [
        'prefix' => 'RcLicensePlesk',
        'script' => 'Plesk',
        'description' => 'Plesk License'
    ],
    'virtualizor' => [
        'prefix' => 'RcLicenseVirtualizor',
        'script' => 'Virtualizor',
        'description' => 'Virtualizor License'
    ],
    'jetbackup' => [
        'prefix' => 'RcLicenseJetBackup',
        'script' => 'JetBackup',
        'description' => 'JetBackup License'
    ],
    'whmreseller' => [
        'prefix' => 'RcLicenseWHMReseller',
        'script' => 'WHMReseller',
        'description' => 'WHM Reseller License'
    ],
    'whmsonic' => [
        'prefix' => 'RcLicenseWHMSonic',
        'script' => 'WHMSonic',
        'description' => 'WHM Sonic License'
    ],
    'directadmin' => [
        'prefix' => 'RcLicenseDA',
        'script' => 'DirectAdmin',
        'description' => 'DirectAdmin License'
    ],
    'dareseller' => [
        'prefix' => 'RcLicenseDAReseller',
        'script' => 'DAReseller',
        'description' => 'DirectAdmin Reseller License'
    ],
    'osm' => [
        'prefix' => 'RcLicenseOSM',
        'script' => 'OSM',
        'description' => 'OSM License'
    ],
    'cxs' => [
        'prefix' => 'RcLicenseCXS',
        'script' => 'CXS',
        'description' => 'CXS License'
    ],
    'cpguard' => [
        'prefix' => 'RcLicenseCPGuard',
        'script' => 'CPGuard',
        'description' => 'CPGuard License'
    ]
];

// Supported Operating Systems
$supportedOS = [
    'cPanel' => [
        'all CentOS versions',
        'all CloudLinux versions',
        'EL** 8/AlmaLinux 8/RockyLinux 8',
        'EL** 9/AlmaLinux 9/RockyLinux 9',
        'AlmaLinux 10 on version 132+',
        'Ubuntu 20.04',
        'Ubuntu 22.04'
    ],
    'other' => [
        'Ubuntu: 18.04 or higher',
        'CloudLinux any version',
        'Centos 6 or higher',
        'Debian: 9 or higher',
        'FreeBSD: 12.04 or higher',
        'EL** 8/AlmaLinux 8/RockyLinux 8',
        'EL** 9/AlmaLinux 9/RockyLinux 9'
    ]
];

// Site configuration
$siteConfig = [
    'title' => 'RC Licensing system',
    'description' => 'RC Licensing system Documentation',
    'company' => 'ResellerCenter.ir',
    'copyright' => '© 2017-2025 RC Licensing system'
];

// Navigation menu structure
$navigationMenu = [
    'clients' => [
        'label' => 'For Clients',
        'items' => [
            ['label' => 'Welcome to Documentation', 'id' => 'welcome', 'file' => 'welcome.php'],
            ['label' => 'AI system NEW', 'id' => 'ai', 'file' => 'ai-system.php'],
            ['label' => 'License troubleshoot NEW', 'id' => 'troubleshoot', 'file' => 'troubleshoot.php'],
            ['label' => 'FAQ', 'id' => 'faq', 'file' => 'faq.php'],
            ['label' => 'Installation', 'id' => 'installation', 'file' => 'installation.php'],
            ['label' => 'SSL settings for cPanel', 'id' => 'ssl', 'file' => 'ssl-settings.php'],
            ['label' => 'Security TIPS for cPanel', 'id' => 'security', 'file' => 'security-tips.php'],
            ['label' => 'Verify LiteSpeed license core/worker numbers', 'id' => 'litespeed', 'file' => 'litespeed-verify.php']
        ]
    ],
    'resellers' => [
        'label' => 'For Resellers',
        'items' => [
            ['label' => 'API doc', 'id' => 'api', 'file' => 'api-doc.php'],
            ['label' => 'Setup WHMCS module', 'id' => 'whmcs', 'file' => 'whmcs-setup.php'],
            ['label' => 'Whats my license commands', 'id' => 'cmds', 'file' => 'license-commands.php']
        ]
    ]
];
?>
