# RC Licensing System - Documentation Portal (PHP Clone)

A complete PHP-based clone of the RC Licensing System documentation site with configurable mirror URLs and license prefixes.

## Overview

This is a fully functional documentation portal for the RC Licensing System, built with PHP and featuring:

- **White background design** with professional typography
- **Responsive sidebar navigation** with organized sections
- **Configurable variables** for mirror URLs and license prefixes
- **All documentation sections** cloned from the original site
- **Clean, maintainable code structure**

## Project Structure

```
license_docs_php/
├── public/                      # Web root directory
│   ├── index.php               # Main entry point
│   ├── welcome.php             # Welcome/home page
│   ├── installation.php        # Installation guide
│   ├── faq.php                 # FAQ page
│   ├── ssl-settings.php        # SSL configuration guide
│   ├── security-tips.php       # Security best practices
│   ├── litespeed-verify.php    # LiteSpeed verification
│   ├── ai-system.php           # AI system features
│   ├── troubleshoot.php        # Troubleshooting guide
│   ├── api-doc.php             # API documentation
│   ├── whmcs-setup.php         # WHMCS module setup
│   └── license-commands.php    # License commands reference
├── includes/
│   ├── config.php              # Configuration file with variables
│   ├── header.php              # Header template
│   └── footer.php              # Footer template
├── data/                        # Data directory (for future use)
└── README.md                    # This file
```

## Configuration

All configurable variables are stored in `includes/config.php`:

### Mirror URL
```php
$mirrorUrl = 'https://mirror.resellercenter.ir';
```

### License Prefix
```php
$prefix = 'RcLicense';
```

### License Types
The system supports all license types with their specific prefixes:
- `RcLicenseCP` - cPanel
- `RcLicenseLSWS` - LiteSpeed
- `RcLicenseCLN` - CloudLinux
- `RcLicenseImunify360` - Imunify360
- `RcLicenseWP` - WordPress
- And 13 more...

### User Agent
```php
$userAgent = 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36';
```

## Features

### 1. Welcome Page
- Latest updates and announcements
- Supported operating systems
- Quick links to other sections

### 2. Installation Guide
- Step-by-step installation instructions
- All license type installation commands
- WHMCS integration guide
- License verification procedures

### 3. FAQ
- Common questions and answers
- Troubleshooting tips
- License command reference

### 4. SSL Settings
- SSL certificate management
- FleetSSL configuration
- Security best practices
- Troubleshooting SSL issues

### 5. Security Tips
- System security recommendations
- cPanel access control
- Firewall configuration
- Malware protection
- Backup strategies

### 6. LiteSpeed Verification
- License information checking
- Core/worker configuration
- Performance optimization
- Monitoring and troubleshooting

### 7. AI System
- Intelligent license detection
- Automated troubleshooting
- Predictive analytics
- Cost optimization

### 8. License Troubleshooting
- Common issues and solutions
- Advanced troubleshooting
- Diagnostic tools
- Support resources

### 9. API Documentation
- REST API endpoints
- Authentication methods
- Code examples (PHP, Python, cURL)
- Error handling
- Rate limiting
- Webhooks

### 10. WHMCS Setup
- Installation and configuration
- Automation rules
- Client portal integration
- Troubleshooting

### 11. License Commands
- Complete command reference
- Batch operations
- Scheduling automation
- Quick reference table

## Installation

### Requirements
- PHP 7.2 or higher
- Web server (Apache, Nginx, or PHP built-in server)
- No database required

### Quick Start

1. **Clone or download the project:**
```bash
cd /home/ubuntu/license_docs_php
```

2. **Start the PHP built-in server:**
```bash
cd public
php -S localhost:8080
```

3. **Access the site:**
Open your browser and navigate to `http://localhost:8080`

### Production Deployment

#### Apache
1. Copy the project to your web root:
```bash
cp -r license_docs_php /var/www/html/
```

2. Create Apache configuration:
```apache
<VirtualHost *:80>
    ServerName docs.license.cheap
    DocumentRoot /var/www/html/license_docs_php/public
    
    <Directory /var/www/html/license_docs_php/public>
        Options Indexes FollowSymLinks
        AllowOverride All
        Require all granted
    </Directory>
</VirtualHost>
```

3. Enable the site:
```bash
a2ensite license-docs
systemctl restart apache2
```

#### Nginx
```nginx
server {
    listen 80;
    server_name docs.license.cheap;
    root /var/www/html/license_docs_php/public;
    index index.php;

    location ~ \.php$ {
        fastcgi_pass unix:/var/run/php-fpm.sock;
        fastcgi_index index.php;
        fastcgi_param SCRIPT_FILENAME $document_root$fastcgi_script_name;
        include fastcgi_params;
    }

    location / {
        try_files $uri $uri/ /index.php?page=$uri;
    }
}
```

## Customization

### Adding New Pages

1. Create a new PHP file in the `public/` directory:
```php
<?php
$pageTitle = 'Your Page Title';
include '../includes/config.php';
include '../includes/header.php';
?>

<h1>Your Page Title</h1>
<p>Your content here...</p>

<?php include '../includes/footer.php'; ?>
```

2. Add the page to the navigation menu in `includes/config.php`:
```php
$navigationMenu = [
    'clients' => [
        'items' => [
            ['label' => 'Your Page', 'id' => 'your-page', 'file' => 'your-page.php'],
            // ... other items
        ]
    ]
];
```

### Changing Colors and Styling

Edit the styles in `includes/header.php`:
```php
header {
    background-color: #6c3fb5;  /* Change header color */
    color: white;
}
```

### Updating Mirror URL

Edit `includes/config.php`:
```php
$mirrorUrl = 'https://your-mirror-url.com';
```

## File Permissions

For production, set proper permissions:

```bash
# Set directory permissions
chmod 755 /var/www/html/license_docs_php
chmod 755 /var/www/html/license_docs_php/public
chmod 755 /var/www/html/license_docs_php/includes

# Set file permissions
chmod 644 /var/www/html/license_docs_php/public/*.php
chmod 644 /var/www/html/license_docs_php/includes/*.php

# Set ownership
chown -R www-data:www-data /var/www/html/license_docs_php
```

## Security Considerations

1. **Input Validation**: All user input is sanitized using `htmlspecialchars()`
2. **Directory Traversal Protection**: Page names are validated with regex
3. **File Inclusion Safety**: All included files are verified to exist
4. **No Database**: Eliminates SQL injection vulnerabilities
5. **Static Content**: No dynamic data processing

## Performance

- **Lightweight**: No database queries
- **Fast Loading**: Pure PHP with minimal overhead
- **Caching**: Can be cached by web servers
- **Scalable**: Handles high traffic easily

## Browser Compatibility

- Chrome/Chromium (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Mobile browsers (iOS Safari, Chrome Mobile)

## Responsive Design

The site is fully responsive and works on:
- Desktop (1920px and above)
- Laptop (1024px - 1920px)
- Tablet (768px - 1024px)
- Mobile (320px - 768px)

## Navigation Structure

### For Clients
- Welcome to Documentation
- AI system (NEW)
- License troubleshoot (NEW)
- FAQ
- Installation
- SSL settings for cPanel
- Security TIPS for cPanel
- Verify LiteSpeed license core/worker numbers

### For Resellers
- API doc
- Setup WHMCS module
- Whats my license commands

## API Integration

The site includes comprehensive API documentation with:
- REST endpoints
- Authentication methods
- Request/response examples
- Error codes
- Rate limiting
- Webhook support

## Support

For issues or questions:
1. Check the FAQ page
2. Review the Troubleshooting guide
3. Contact support through the main website

## License

© 2017-2025 RC Licensing system. All rights reserved.

## Changelog

### Version 1.0 (Initial Release)
- Complete documentation site clone
- All sections implemented
- Configurable variables
- White background design
- Responsive layout
- API documentation
- WHMCS integration guide

## Future Enhancements

- Search functionality
- Dark mode toggle
- Multi-language support
- Interactive API tester
- Video tutorials
- Knowledge base articles
- Community forum integration

## Technical Stack

- **Language**: PHP 7.2+
- **Frontend**: HTML5, CSS3
- **Server**: Apache/Nginx/PHP Built-in
- **Database**: None (static content)
- **Dependencies**: None (pure PHP)

## Development

### Running Locally
```bash
cd /home/ubuntu/license_docs_php/public
php -S localhost:8080
```

### Testing
Visit `http://localhost:8080` and navigate through all pages to verify functionality.

### Debugging
Enable PHP error reporting in `includes/config.php`:
```php
ini_set('display_errors', 1);
error_reporting(E_ALL);
```

## Credits

Created as a complete clone of the RC Licensing System documentation portal with enhanced PHP architecture and configurable variables.

---

For more information, visit: https://license.cheap
